import os
import pandas as pd
from sklearn.model_selection import train_test_split

def divisione(path_dataset, path_output, nome_gruppo):
    """
    Divide il dataset in:
    - Construction Set (80%) -> suddiviso in Training Set (75%) e Validation Set (25%)
    - Test Set (20%)

    La suddivisione viene fatta separatamente per ciascun gruppo (I e F).

    Args:
        path_dataset (str): Percorso del dataset da suddividere.
        nome_gruppo (str): Nome del gruppo (es. "I" o "F") per creare le relative cartelle.

    Returns:
        dict: Percorsi delle cartelle create per il dataset.
    """
    # Definizione dei path di output
    training_path = os.path.join(path_output, f"{nome_gruppo}_training_set.csv")
    validation_path = os.path.join(path_output, f"{nome_gruppo}_validation_set.csv")  
    test_path = os.path.join(path_output, f"{nome_gruppo}_test_set.csv")  

    # leggo il dataset aggregato
    dataset = pd.read_csv(path_dataset)
    # Divisione in Construction Set (80%) e Test Set (20%)
    construction_set, test_set = train_test_split(dataset, test_size=0.2, random_state=42)
    # divisione del Construction set in Trainig(75%) e Validation(25%) 
    training_set, validation_set = train_test_split(construction_set, test_size=0.25, random_state=42)
    
    # salvataggio dei nuovi dataset divisi
    test_set.to_csv(test_path, index=False)
    training_set.to_csv(training_path, index=False)
    validation_set.to_csv(validation_path, index=False)
    
    print(f"Dataset '{nome_gruppo}' diviso e salvato in:\n"
      f" - Training: {training_path}\n"
      f" - Validation: {validation_path}\n"
      f" - Test: {test_path}")

    
    return  training_path, validation_path, test_path